#!/usr/bin/php -q
<?php

//Listen to incoming e-mails
$sock = fopen("php://stdin", 'r');
$email = '';
//Read e-mail into buffer
while (!feof($sock)) {
    $email .= fread($sock, 1024);
}
//Close socket
fclose($sock);

/*
$fileData = date("Y-m-d H:i:s") . PHP_EOL . 
'-----------------------------------------------------------------' . PHP_EOL .
$email . PHP_EOL . 
'-----------------------------------------------------------------' . PHP_EOL;


file_put_contents('./pipemail.txt', $fileData, FILE_APPEND);

exit;
*/

	include_once 'mime_parser.php';
	include_once 'rfc822_addresses.php';

	$mime = new mime_parser_class;
	
	/*
	 * Set to 0 for parsing a single message file
	 * Set to 1 for parsing multiple messages in a single file in the mbox format
	 */
	$mime->mbox = 0;
	
	/*
	 * Set to 0 for not decoding the message bodies
	 */
	$mime->decode_bodies = 1;

	/*
	 * Set to 0 to make syntax errors make the decoding fail
	 */
	$mime->ignore_syntax_errors = 1;

	/*
	 * Set to 0 to avoid keeping track of the lines of the message data
	 */
	$mime->track_lines = 1;

	/*
	 * Set to 1 to make message parts be saved with original file names
	 * when the SaveBody parameter is used.
	 */
	$mime->use_part_file_names = 0;

	/*
	 * Set this variable with entries that define MIME types not yet
	 * recognized by the Analyze class function.
	 */
	$mime->custom_mime_types = array(
		'application/vnd.openxmlformats-officedocument.wordprocessingml.document'=>array(
			'Type' => 'ms-word',
			'Description' => 'Word processing document in Microsoft Office OpenXML format'
		)
	);



	$parameters=array(
		'Data'=> $email,
	);

	$mime->Decode($parameters, $decoded);
	
	$fileData = date("Y-m-d H:i:s") . '-Request-' . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL .
	print_r($decoded, true) . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL;

	file_put_contents('./decodedmail.txt', $fileData, FILE_APPEND);
	
	$fields = array();
	
	if(isset($decoded[0]['ExtractedAddresses']['to:'][0]['address'])){
	    $toAddress = $decoded[0]['ExtractedAddresses']['to:'][0]['address'];
	    $arrToAdd = explode('@', $toAddress);
	    $arrDash = explode('-', $arrToAdd[0]);
	    if($arrDash[0] == 'test' && $arrToAdd[1] == 'taskque.com'){
	    	if(isset($arrDash[1])){
	    		$project_id = $arrDash[1];
	    		$fields['project_id'] = $project_id;
	    		# $fileData = 'Task to created in Project ID - ' . $project_id;
	    	} else {
	    		# $fileData = 'Task to created in Todo';
	    	}	    	
	    	
		# file_put_contents('./pipemail.txt', $fileData, FILE_APPEND);
	    } else {
	    	exit;
	    }
	} else {
		exit;
	}
	
	$from = $decoded[0]['ExtractedAddresses']['from:'][0]['address'];
	$fields['email'] = $from;
	
	$subject = $decoded[0]['Headers']['subject:'];
	$fields['name'] = $subject;
	
	$message = '';
	if(isset($decoded[0]['Parts'][0]['Parts'][0]['Body'])){
	    $message = $decoded[0]['Parts'][0]['Parts'][0]['Body'];
	}
	
	if(isset($decoded[0]['Parts'][0]['Body'])){
	    $message = $decoded[0]['Parts'][0]['Body'];
	}
	
	if(isset($decoded[0]['Body'])){
	    $message = $decoded[0]['Body'];
	}
	
	$fields['desc'] = $message;
	
	if(isset($decoded[0]['ExtractedAddresses']['to:'][1]['address'])){
	    $assign_to = $decoded[0]['ExtractedAddresses']['to:'][1]['address'];
	    $fields['assign_to'] = $assign_to;
	}
	
	if(isset($decoded[0]['ExtractedAddresses']['cc:'])){
	    $followers = '';
	    
	    foreach($decoded[0]['ExtractedAddresses']['cc:'] as $ccEmail){
	        $followers .= $ccEmail['address'] . ',';
            }
        
            $followers = rtrim($followers, ',');
        
            if(!empty($followers)){
                $fields['followers'] = $followers;
            }
	}
	
	$attachments = array();
	foreach($decoded[0]['Parts'] as $part){	    
	    if(isset($part['FileDisposition']) && $part['FileDisposition'] == 'attachment'){
	        //echo $part['FileName'] . '<br />';
	        $attachments[] = array(
	            'name' => $part['FileName'],
	            'size' => $part['BodyLength'],
	            'data' => $part['Body']
	        );
	    }
	}
	
	if(count($attachments) > 0){
            $fields['attachments'] = $attachments;
        }
        
        $getAccessUrl = 'http://dev.taskque.com/dev/tasks/EmailtaskcreatorGetAccess';
	$url = 'http://dev.taskque.com/dev/tasks/Emailtaskcreator';
    
        $login = [
            'email' => $fields['email']
        ];
        
        $login_string = http_build_query($login);
        
        $ckfile = tmpfile();
        
        //open connection
        $ch = curl_init();
    
        //set the url, number of POST vars, POST data
        curl_setopt($ch,CURLOPT_URL, $getAccessUrl);
        curl_setopt($ch,CURLOPT_POST, count($login));
        curl_setopt($ch,CURLOPT_POSTFIELDS, $login_string);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt ($ch, CURLOPT_COOKIEJAR, $ckfile);
        curl_setopt ($ch, CURLOPT_COOKIEFILE, $ckfile);
        
        $result = curl_exec($ch);
        
        $fields_string = http_build_query($fields);
        
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_POST, count($fields));
        curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
        
        $fileData = date("Y-m-d H:i:s") . '-Request-' . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL .
	print_r($fields, true) . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL;

	file_put_contents('./pipemail.txt', $fileData, FILE_APPEND);
        
        $result = curl_exec($ch);
        
        $fileData = date("Y-m-d H:i:s") . '-Response-' . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL .
	$result . PHP_EOL . 
	'-----------------------------------------------------------------' . PHP_EOL;

	file_put_contents('./pipemail.txt', $fileData, FILE_APPEND);
        
        //close connection
        curl_close($ch);
    
        fclose($ckfile);
        
        
?>